<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Registration extends Model 
{

    protected $table = 'Registrations';
    public $timestamps = true;
    protected $fillable = array('student_id', 'teacher_id', 'classroom_id', 'program_id', 'programType_id', 'Invoice_id');

    public function registrationStudentRelation()
    {
        return $this->belongsTo('App\Models\Student', 'student_id');
    }

    public function registrationTeacherRelation()
    {
        return $this->belongsTo('App\Models\Teacher', 'teacher_id');
    }

    public function registrationClassroomRelation()
    {
        return $this->belongsTo('App\Models\Classroom', 'classroom_id');
    }

    public function registrationProgramRelation()
    {
        return $this->belongsTo('App\Models\Program', 'program_id');
    }

    public function registrationProgramTypeRelation()
    {
        return $this->belongsTo('App\Models\Program_Types', 'programType_id');
    }

    public function registrationInvoiceRelation()
    {
        return $this->belongsTo('App\Models\Invoice', 'Invoice_id');
    }

}